//=============================================================================
// 5% sized variant of original, changes fov to match.
//=============================================================================
class MuyMuyPequeno extends MSGunship;

var float NewFOV;

function FireMissiles()
{
 local DeusExProjectile P, P2;
  
 P = Spawn(class'GunshipRocketM', Self,,Location + (MissileOffset >> Rotation), Rotation);
 P2 = Spawn(class'GunshipRocketM', Self,,Location + (MissileOffset * vect(1,-1,1) >> Rotation), Rotation);

 P.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
 P2.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
}

function FireCannons()
{
 local DeusExProjectile P, P2;
  
 P = Spawn(class'GunshipRoundM', Self,,Location + (CannonOffset >> Rotation), Rotation);
 P2 = Spawn(class'GunshipRoundM', Self,,Location + (CannonOffset * vect(1,-1,1) >> Rotation), Rotation);

 P.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
 P2.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
}

function FireArtillery()
{
 local DeusExProjectile P, P2;
  
 P = Spawn(class'GunshipShellM', Self,,Location + (ArtilleryOffset >> Rotation), Rotation);
 P2 = Spawn(class'GunshipShellM', Self,,Location + (ArtilleryOffset * vect(1,-1,1) >> Rotation), Rotation);

 P.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
 P2.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
}

function FireLasers()
{
 local DeusExProjectile P, P2;
  
 P = Spawn(class'GunshipLaserM', Self,,Location + (LaserOffset >> Rotation), Rotation);
 P2 = Spawn(class'GunshipLaserM', Self,,Location + (LaserOffset * vect(1,-1,1) >> Rotation), Rotation);

 P.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
 P2.Velocity += (vect(1,0,0) >> Rotation) * vsize(Velocity * vect(1,0,0));
}

function DropBombs()
{
 local DeusExProjectile P, P2;
  
 P = Spawn(class'GunshipBombM', Self,,Location + (BombOffset >> Rotation), Rotation);
 P2 = Spawn(class'GunshipBombM', Self,,Location + (BombOffset * vect(1,-1,1) >> Rotation), Rotation);
}


function Frob(Actor Frobber, Inventory frobWith)
{
  local DeusExPlayer player;

  player = DeusExPlayer(Frobber);

  if ((player != None) && (Pilot == None))
  {
    SetTimer(0.02, True);
    Pilot = player;
    SetSpecialPhysics(True);
    GiveControls(Player);
    Player.ReducedDamageType = 'All';
    return;
  }
  if ((player != None) && (Pilot != None))
  {
    Pilot.SetLocation(Self.Location + vect(0,0,1) * (CollisionHeight / 2 + Pilot.CollisionHeight + 48)); 
    Pilot.StartWalk();

    Pilot.ConsoleCommand("Fov 75");
    Pilot.DrawScale = 1.000000;

    SetTimer(0, False);
    Pilot = None; 
    SetSpecialPhysics(False);
    DestroyControls();
    Player.ReducedDamageType = 'None';
    return;
  }
}

function GiveControls(DeusExPlayer P)
{
 local int i;
 
 ControlStick = Spawn(class'GunshipControl',None,,Location);
 ControlStick.Frob(P, None);
 ControlStick.Master = Self;
 ControlStick.NumModes = NumberOfModes;
 
 for(i=0; i<NumberOfModes + 1; i++)
 {
  ControlStick.ModeNames[i] = ModeTypes[i];
 }
 
 ControlStick.CurrentMode = ModeTypes[0];
 ControlStick.AdjustStats();
 
 //P.SetInHand(ControlStick);
}

function DestroyControls()
{
 ControlStick.Destroy();
}

function SetSpecialPhysics(bool B)
{
 if (B)
 {
  Mesh = None;
  SetPhysics(PHYS_Projectile);
  SetCollision(True, True, False);
  bCollideWorld = True;
  bBlockPlayers = False;
  bHighlight = False;
  AmbientSound = ThrustSound;
 }
 if (!B)
 {
  Mesh = Default.Mesh;
  SetPhysics(PHYS_Falling);
  bBlockPlayers = True;
  bCollideWorld = True;
  SetCollision(True, True, True);
  SetRotation(Rot(0,0,0));
  AmbientSound = None;
  bHighlight = True;
 }
}

function Landed(Vector H)
{
 if (Pilot == None) Super.Landed(H);
 
 if (Pilot != None)
 {
  SetLocation(Location + vect(0,0,0.25));
 }
}

function UpdateHealthSprite()
{
 //if (HealthSprite == None) SpawnHealthSprite();
 
 //HealthSprite.SetLocation(Location + (CockpitOffset * vect(-1,0,0) >> Rotation));
 //HealthSprite.UpdateTexture(hitPoints, Default.HitPoints);
}

/*function SpawnHealthSprite()
{
 HealthSprite = Spawn(class'HealthSprite', Self);
 HealthSprite.SetTimer(0.02, True);
}*/

function Timer()
{
 local Vector TempVel;
 local Rotator TempRot; 
 local int TempInt;
 

  /*if (Accelerator < 0.25) Accelerator = 0.25;
  if (Accelerator > 1) Accelerator = 1;*/

 UpdateHealthSprite();
 
 if (hitPoints < Default.hitPoints)
 {
  hitPoints++;
  ResetScaleGlow();
 }
 
 SetPhysics(PHYS_Projectile);
 
 if (Pilot != None) if (Pilot.InHand != ControlStick) Pilot.PutInHand(ControlStick);
 
 TempInt = 1;
 if (Pilot.Acceleration.X < 0) TempInt = -1;
 if (Pilot.bDuck == 1) TempInt = 0;
 
 TempRot = rot(0,0,0);
 TempRot.Pitch = Rotation.Pitch * TempInt;
 
 if (Pilot != None)
 {
  TempVel = (Pilot.Acceleration >> TempRot) * VelocityMult * vehiclespeed * Accelerator;
 
 //Yes Duck
 if (Pilot.bDuck == 1) TempVel += vect(0,0,1) * VehicleSpeed * SpeedMult;

 if ((Rotator(TempVel) - Pilot.Rotation).Yaw > 9102 && (Rotator(TempVel) - Pilot.Rotation).Yaw < 56434)
 {
  TempVel.Z = 0;
 }
 if ((Rotator(TempVel) - Pilot.Rotation).Yaw < -9102 && (Rotator(TempVel) - Pilot.Rotation).Yaw > -56434)
 {
  TempVel.Z = 0;
 }
 
 Pilot.SetLocation(Location + (CockpitOffset >> Rotation));
 Pilot.SetPhysics(PHYS_None);
 Pilot.Landed(Vect(0,0,0));
 }
 
 if (VSize(Velocity) < 20)
 {  
 }
 if (VSize(Velocity * vect(1,1,0)) > 20)
 {
 }
 
 SoundVolume = 255 * Accelerator;
 SoundRadius = 255 * Accelerator;
 
 if (VSize(Pilot.Acceleration * vect(1,1,0)) > 20)
 {
  LastFly = 0;
  Accelerator += 0.0125;
  if (Accelerator > 1) Accelerator = 1;

  LastVel = TempVel / Accelerator;
 }
 if (VSize(Pilot.Acceleration) < 20)
 {
  LastFly += 0.05;
  Accelerator -= 0.025;
  if (Accelerator < 0.0) Accelerator = 0.0;

  TempVel = LastVel * Accelerator;
 }

 if (Pilot != None) SetRotation(Pilot.ViewRotation);
 Acceleration = TempVel;
 Velocity = TempVel;
 
 UpdateMini();
}

function UpdateMini()
{
 Pilot.SetCollisionSize(1, 4.8);
 Pilot.ConsoleCommand("Fov "$NewFOV);
 Pilot.DrawScale = 0.050000;
}

function Bump(actor Other)
{
	local DeusExWeapon dxWeapon;
	local DeusExPlayer dxPlayer;
	local float        damage;

	Super(DeusExDecoration).Bump(Other);

}

defaultproperties
{
     CollisionHeight=2.750000
     CollisionRadius=6.250000
     Mesh=LODMesh'MuyPequeno'
     ItemName="Muy Muy Pequeno"
     NumberOfModes=4
     Drawscale=0.050000
     ModeTypes(0)="Cannons"
     ModeTypes(1)="Missiles"
     ModeTypes(2)="Bombs"
     ModeTypes(3)="Lasers"
     ModeTypes(4)="Artillery"
     MissileOffset=(X=1.925.000000,Y=3.250000,Z=-0.275000)
     CannonOffset=(X=6.600000,Y=0.800000,Z=-0.875000)
     BombOffset=(X=0.000000,Y=0.800000,Z=-2.100000)

     ArtilleryOffset=(X=1.925,Y=3.250000,Z=-0.275000)
     LaserOffset=(X=1.925,Y=0.800000,Z=-0.875000)
     CockpitOffset=(X=-0.400000,Y=0.000000,Z=0.000000)

     NewFOV=3.750000
     SpeedMult=10
}
